window.Event = new class {
	constructor() {
		this.vue = new Vue();
	}
	fire(event, data = null) {
		this.vue.$emit(event, data);
	}
	listen(event, callback) {
		this.vue.$on(event, callback);
	}
};

Vue.component('form-shipping', {
	props: {
		isHidden: {
			type: Boolean,
			required: true
		}
	},
	template: '<div v-if="!this.isHidden" class="alert alert-danger"><a style="color: red" href="#" v-on:click=" isHidden = true "><i class ="fa fa-times" aria-hidden="true"></i></a> Silahkan pilih Biaya Pengiriman</div>'
});

Vue.component('alert-form', {
	props: ['total', 'limit', 'price'],
	methods: {
		formatPrice(value) {
			let val = (value / 1).toFixed(0).replace('.', ',')
			return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
		}
	},
	template: '<div v-if="price > limit" class="alert alert-success"> Dapat potongan ongkos kirim senilai <b>Rp {{ total }}</b> dengan belanja minimal <b>Rp. {{ formatPrice(limit) }}</b></div>'
});

Vue.component("alert-city", {
	template: '<a href="tel:+628116540877"><div class="alert alert-success">Selamat anda mendapatkan Extra potongan ongkos kirim, silahkan hubungi customer care kami <b>081-1654-0877</b></div></a>'
});

Vue.component('shippings-component', {
	props: ['limit', 'price'],
	template: '<div style="color: #fe385f;" v-if="price > limit">Potongan ongkos kirim : </b></div></div>'
});

Vue.component('alert-shipping', {
	props: ['total', 'limit', 'price', 'promo'],
	methods: {
		formatPrice(value) {
			let val = (value / 1).toFixed(0).replace('.', ',')
			return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
		}
	},
	template: '<div style="color: #fe385f;" v-if="price > limit"> - Rp. <b>{{ formatPrice(Number(total) + Number(promo)) }} </b></div>'
});

Vue.component('total-component', {
	props: ['total', 'tweight', 'fee', 'limit', 'price', 'promo'],
	methods: {
		formatPrice(value) {
			let val = (value / 1).toFixed(0).replace('.', ',')
			return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
		}
	},
	template: '<div v-if="price > limit">Rp. <b>{{ formatPrice(total * tweight - fee - promo ) }}</b></div>'
});

Vue.component('shipping-component', {
	props: ['limit', 'price'],
	template: '<div v-if="price > limit">Total Ongkos Kirim : </div>'
});

Vue.component('total-price', {
	template: '<div class="pull-right">Rp. <b>{{ total }}</b></div>'
});

Vue.component('total-quantity', {
	props: ['qty'],
	template: '<div class="pull-right"><b>{{ qty }}</b> gram</div>'
});

new Vue({
	delimiters: ['%%', '%%'],
	el: '#appForm',
	data: {
		key: '',
		coupon: '',
		coupons: '',
		rcoupons: '',
		price: '',
		isHidden: true,
		isHide: true,
		total: 0,
		shippings: [],
		shipping: false,
		prov: '',
		txtInput: '',
		totalShipping: '',
		gkey: 'secret-root',
		base_url: window.location.origin
	},
	computed: {
		isDisabled: function () {
			return !this.key;
		}
	},
	methods: {
		OnCouponApplied: function () {
			Event.fire('applied');
		},
		formatPrice: function (value) {

			let val = (value / 1).toFixed(0).replace('.', ',')
			return val.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
		},
		minQty: function (id, event) {

			if (event) event.preventDefault();
			axios.get(this.base_url + '/quantity?do=minqty&id=' + id)
				.then(Response => {
					this.total = Response.data;
					localStorage.setItem('totals', CryptoJS.AES.encrypt(JSON.stringify(Response.data), this.gkey).toString());
				});
		},
		addQty: function (id, event) {

			if (event) event.preventDefault();
			axios.get(this.base_url + '/quantity?do=addqty&id=' + id)
				.then(Response => {
					this.total = Response.data;
					localStorage.setItem('totals', CryptoJS.AES.encrypt(JSON.stringify(Response.data), this.gkey).toString());
				});
		},
		listShippings: function (weight, kecamatan, event) {

			if (event) event.preventDefault();
			axios.get(this.base_url + '/checkongkir/listShipping?w=' + weight + '&kecamatan=' + kecamatan)
				.then(Response => this.shippings = Response.data);
		},
		onChange: function (code, event) {

			axios.get(this.base_url + '/checkongkir/shippingCheck?idkota_tujuan=' + code + '&namePaket=' + this.key)
				.then(Response => this.totalShipping = Response.data);
		},
		checkCode: function (code, kecamatan, price, event) {
			if (event) event.preventDefault();
			axios.get(this.base_url + '/checkcode?kupon=' + code + '&kecamatan=' + kecamatan + '&price=' + price)
				.then(Response => this.coupons = Response.data);
		},
		codePromo: function (event) {

			if (event) event.preventDefault();
			var kecamatan = document.getElementById('idkota_tujuan').value;
			var price = document.getElementById('price').value;
			axios.get(this.base_url + '/checkcode/codepromo?kupon=' + this.coupon + '&kecamatan=' + kecamatan + '&price=' + price)
				.then(Response => this.rcoupons = Response.data);
		},
	},
	created() {
		Event.listen('applied', () => alert('handle!'));
	},
	mounted() {
		if (localStorage.totals) {
			var getTotals = window.localStorage.getItem('totals');
			this.total = JSON.parse(CryptoJS.AES.decrypt(getTotals, this.gkey).toString(CryptoJS.enc.Utf8));
		}
	},
});