/* global jQuery */
/* global g1 */
/* global enquire */
/* global console */

(function (context, $) {

    'use strict';

    $(document).ready(function () {
        var menu = Menu($('#g1-primary-nav'));
        GlobalToggleButton(menu);
    });

    function Menu ($menu) {
        var that = {};

        that.init = function () {
            that.initVars();
            that.registerEventsHandlers();

            // add toggle to menu
            $('.menu-item-has-children > a').append( '<span class="g1-link-toggle"></span>' );

            return that;
        };

        that.initVars = function () {
            that.mode = 'regular';
            that.menuType = 'regular';
        };

        that.registerEventsHandlers = function () {
            that.handleMenuItemClick();
            that.handleMenuItemFocusOut();
        };

        that.handleMenuItemFocusOut = function () {
            $('body').on('click', function (e) {
                if ($(e.target).parents('.mtm-drop-expanded').length === 0 ) {
                    that.collapseAllOpenedSubmenus();
                }
            });
        };

        that.handleMenuItemClick = function () {
            that.getMenu().on('click', '.menu-item > a', function (e) {
                var isSimpleList = that.isMode('list');

                if (g1.isTouchDevice() || isSimpleList) {
                    that.handleMenuTouchEvent($(this), e);
                }
            });
        };

        that.handleMenuTouchEvent = function ($link, event) {
            var $li = $link.parent('li');

            if (that.isMode('regular')) {
                that.collapseAllOpenedSubmenus();
            } else {
                that.collapseAllOpenedSubmenus($li);
            }

            if ($li.hasClass('menu-item-has-children')) {
                event.preventDefault();


                var $helper = $li.find('ul.sub-menu:first > li.g1-menu-item-helper');

                if ($helper.length === 0) {
                    var href = $link.attr('href');
                    var anchor = 'Go to <span class="mtm-item-helper-title">'+ $link.text() +'</span>';

                    $helper = $('<li class="menu-item g1-menu-item-helper"><a class="mtm-link" href="'+ href +'"><span class="mtm-link-text"><span class="mtm-link-title">' + anchor +'</span></span></a></li>');

                    $li.find('ul.sub-menu:first').prepend($helper);
                }


                if (!$li.is('.mtm-drop-expanded')) {
                    $li.find('.mtm-drop-expanded .g1-menu-item-helper').remove();
                    $li.addClass('mtm-drop-expanded');
                } else {
                    $li.find('.mtm-drop-expanded').removeClass('mtm-drop-expanded');
                    $li.removeClass('mtm-drop-expanded');
                }
            }
        };

        that.collapseAllOpenedSubmenus = function ($currentItem) {
            if ($currentItem) {
                var $topLevelLi = $currentItem.parents('li.mtm-item-lvl-0');
                var $currentMenu = $currentItem.parents('nav.mtm');

                // collapse all opened submenus in current menu, beside current subtree
                $topLevelLi.siblings('li').find('.mtm-drop-expanded').removeClass('mtm-drop-expanded');

                // collapse all opened submenus in all other menus
                $('nav.mtm').not($currentMenu).find('.mtm-drop-expanded').removeClass('mtm-drop-expanded');
            } else {
                // collapse all opened, site wide, submenus
                $('.mtm-drop-expanded').removeClass('mtm-drop-expanded');
            }
        };

        that.switchToListMenu = function () {
            if (that.isMode('list')) {
                return that.log('Menu is already in the LIST mode!');
            }

            that.setMode('list');
        };

        // regular menu
        that.switchToRegularMenu = function () {
            if ( that.isMode('regular')) {
                return that.log('Menu is already in the REGULAR mode!');
            }

            // remove "Go to" helper
            that.getMenu().find('.g1-menu-item-helper').remove();

            that.setMode('regular');
        };


        that.getMenu = function () {
            return $menu;
        };

        that.getMenuClass = function () {
            return that.getMenu().attr('class');
        };

        that.getWindowWidth = function () {
            if (typeof window.innerWidth !== 'undefined') {
                return window.innerWidth;
            }

            return $(window).width();
        };

        that.getWindowHeight = function () {
            if (typeof window.innerHeight !== 'undefined') {
                return window.innerHeight;
            }

            return $(window).height();
        };

        that.setMode = function (mode) {
            that.getMenu().
                removeClass('mtm-' + that.mode).
                addClass('mtm-' + mode);

            that.mode = mode;

            that.log('Menu mode "'+ mode +'" set.');
        };

        that.isMode = function (mode) {
            return that.mode === mode;
        };

        that.log = function (msg) {
            if (typeof console !== 'undefined') {
                console.log(msg);
            }
        };

        return that.init();
    }

    function Canvas () {
        var that = {};
        var listeners = {
            'open': [],
            'close': []
        };

        var currentContent = null;

        var init = function () {
            var $overlay = $( '.g1-canvas-overlay');

            // toogle canvas events
            $overlay.on('click', that.toggle);

            $('.g1-canvas').on('toggle-canvas', function () {
                that.toggle();
            });

            $('.g1-canvas .g1-canvas-toggle').on('click', that.toggle);

            return that;
        };

        that.open = function (content) {
            window.requestAnimationFrame(function () {
                $('html').
                    addClass('g1-off-global').
                    removeClass('mtm-off-from-global mtm-off-from-local');

                currentContent = content;
                var $canvas = $('.g1-canvas-global');

                if (content !== null) {
                    if (typeof content === 'string') {
                        $canvas.find('.g1-canvas-content').html(content);
                    } else {
                        $canvas.find('.g1-canvas-content').empty().append(content);
                    }

                    // notify about adding new content to DOM so other elements can be reloaded
                    $canvas.find('.g1-canvas-content').trigger('g1-new-content');
                }

                $canvas.scrollTop(0);

                that.notify('open');
            });
        };

        that.close = function () {
            window.requestAnimationFrame(function () {
                $('html').removeClass('g1-off-global');

                that.notify('close');
            });
        };

        that.toggle = function (e) {
            if (e) {
                e.preventDefault();
            }

            // is opened?
            if ( $('html').hasClass('g1-off-global') ) {
                that.close();
            } else {
                that.open(null);
            }
        };

        that.notify = function (eventType) {
            var callbacks = listeners[eventType];

            for (var i = 0; i < callbacks.length; i++) {
                callbacks[i](currentContent);
            }
        };

        that.on = function (eventType, listener) {
            listeners[eventType].push(listener);
        };

        return init();
    }

    function GlobalToggleButton (menu) {
        var $toggle = $('.g1-hamburger');

        if ($toggle.length === 0) {
            return;
        }

        var canvas;

        // handle open/close menus in canvas
        $toggle.on('click', function (e) {
            e.preventDefault();

            var $menu = menu.getMenu();
            var $placeholder = $('<span id="menu-placeholder-'+ $menu.attr('id') +'">');

            $menu.after($placeholder);
            $menu.detach();

            canvas = Canvas();
            canvas.open($menu);
            menu.switchToListMenu();

            canvas.on('close', function (content) {
                $(content).each(function () {
                    var $menu = $(this);

                    var $placeholder = $('#menu-placeholder-' + $menu.attr('id'));

                    if ($placeholder.length > 0) {
                        $placeholder.replaceWith($menu);
                        menu.switchToRegularMenu();
                    }
                });

                canvas = undefined;
            });
        });

        var closeCanvasMenu = function () {
            if (canvas) {
                canvas.close();
            }
        };

        // build css to hide toggle button above the maxCanvasBreakpoint value
        enquire.register('screen and ( min-width: 700px )', {
            match : function() {
                closeCanvasMenu();
            }
        });
    }

})(window, jQuery);
